<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InviteReponseQuestion extends Model 
{

    protected $table = 'invites_reponses_questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'invite_id', 'reponse_question_id', 'statut');
    protected $visible = array('slug', 'invite_id', 'reponse_question_id', 'statut');

    public function invite()
    {
        return $this->belongsTo('App\Models\Invite', 'invite_id');
    }

    public function reponseQuestion()
    {
        return $this->belongsTo('App\Models\ReponseQuestion', 'reponse_question_id');
    }

}